cd "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/"

use "hcn_only_raw_mse_diff tavg 2000.dta", clear

append using "hcn_only_adj_mse_diff tavg 2000.dta"
append using "crn_only_mse_diff tavg 2000.dta"

gen mse = raw_mse
replace mse = adj_mse if mse == .
replace mse = crn_mse if mse == .

drop raw_mse adj_mse crn_mse

keep mse distance type

tempfile combined_data
save "`combined_data'", replace

clear
tempfile results
cap gen distance = .
keep if _n < 0
save "`results'", replace

forvalues distance = 50(10)2000 {
	quietly {
	use "`combined_data'", clear
	keep if distance >= `distance' - 50 & distance < `distance' + 50
	su mse if type == "raw", detail
	local raw_mean = r(mean)
	su mse if type == "adj", detail
	local adj_mean = r(mean)
	su mse if type == "crn", detail
	local crn_mean = r(mean)
	clear
	set obs 1
	gen distance = `distance'
	gen raw_mean = `raw_mean'
	gen adj_mean = `adj_mean'
	gen crn_mean = `crn_mean'
	append using "`results'"
	save "`results'", replace
	}
}

use "`results'", clear	

keep if distance <= 2000

#delimit ;
twoway 
	(line raw_mean distance, lcolor(blue) lwidth(medthin))
	(line adj_mean distance, lcolor(red) lwidth(medthin))
	(line crn_mean distance, lcolor(green) lwidth(medthin))
    ,
	title("Station Pair Mean Squared Error vs. Distance", size(medium))
    ytitle("MSE in Anomaly Difference", size(small))
    xtitle("Distance (miles)", size(small))
  	xlabel(0(200)2000,labsize(small))
  	ylabel(0(1)6, gmax glcolor(black) glpattern(dot) labsize(small)) 
  	graphregion(color(white) lcolor(ebg))
	legend(region(fcolor(gs15) lcolor(ebg)) size(vsmall) position(12) label(1 "USHCN Raw") label(2 "USHCN Adj") label(3 "USCRN") order(1 2 3) col(3))
    plotregion( m(b=0) )
	;
#delimit cr
graph export "CRN HCN Pair Diff MSE by Distance 2000.png", replace width(1000)
